local assets =
{
    Asset("ANIM", "anim/ast_item.zip"),
	Asset("ANIM", "anim/cuisine.zip"),
	Asset("ATLAS", "images/inventoryimages/ast_ai.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_board.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_circuit_board.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_cpu.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_focus.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_gears.xml"),
	Asset("ATLAS", "images/inventoryimages/ast_memorybank.xml"),
	Asset("ATLAS", "images/inventoryimages/coil.xml"),
	Asset("ATLAS", "images/inventoryimages/water.xml"),
}

local function buildgene(lei)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ast_item")
    inst.AnimState:SetBuild("ast_item")
    inst.AnimState:PlayAnimation(lei)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..lei..".xml"
    inst:AddComponent("selfstacker")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst.Transform:SetScale(1.5, 1.5, 1.5)

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab(lei, fn, assets)

end
local function waterfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cuisine")
    inst.AnimState:SetBuild("cuisine")
    inst.AnimState:PlayAnimation("water")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "water"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/water.xml"
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst:AddComponent("edible")
    inst.components.edible.foodtype = "GENERIC"
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = 0
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERFAST)
    inst.components.perishable:StartPerishing()
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return 
Prefab("astwater", waterfn, assets),
    buildgene("ast_ai"),
	buildgene("ast_board"),
	buildgene("ast_circuit_board"),
	buildgene("ast_cpu"),
	buildgene("ast_focus"),
	buildgene("ast_gears"),
	buildgene("ast_memorybank"),
    buildgene("coil",true)
	